/*
 * CollisionHandlerPusherNode.h
 *
 * Created 8/8/2009 By Johnny Huynh
 *
 * Version 00.00.02 8/22/2009
 *
 * Copyright Information:
 * All content copyright  2009 Johnny Huynh. All rights reserved.
 */
 
 #ifndef COLLISION_HANDLER_PUSHER_NODE_H
 #define COLLISION_HANDLER_PUSHER_NODE_H
 
 template <typename T> class CollisionHandlerPusherNode;
 
 #include "nodePath.h"
 
 // For collision handling
 #include "CollisionHandlerEventNode.h"
 #include "collisionHandlerPusher.h"
 
 #include "global.h"
 #include "ObjectCollection.h"
 
 /**
  * Class specification for CollisionHandlerPusherNode
  */
 template <typename T>
 class CollisionHandlerPusherNode : public CollisionHandlerEventNode<T>
 {
 // Data Members
 private:
 
 // Special Purpose Functions
 protected:
    CollisionHandlerPusherNode( const CollisionHandlerPusherNode<T>& chpn, CollisionHandlerPusher* collision_handler_Ptr ); // for get_copy() function
 
 // Local Functions
 public:
    CollisionHandlerPusherNode( const std::string& name );
    CollisionHandlerPusherNode( const CollisionHandlerPusherNode<T>& chpn );
    virtual ~CollisionHandlerPusherNode();
    //virtual inline CollisionHandlerPusherNode<T>& operator=( const CollisionHandlerPusherNode<T>& chpn );
    virtual inline PT(CollisionHandlerEventNode<T>) get_copy() const;
    //virtual inline void initialize_collision_handler( NodePath& node_path );
    virtual inline void reparent_to( NodePath& node_path ); // can be treated like a NodePath function
 
    // NodePath functions
    /*virtual inline void remove_node() 
    {
        if ( _collision_handler_Ptr != NULL )
        {
            PT(CollisionHandlerPusher) pusher_handler_Ptr( DCAST(CollisionHandlerPusher, _collision_handler_Ptr) );
            pusher_handler_Ptr->clear_center();
            pusher_handler_Ptr->clear_colliders();
        }
           
        CollisionHandlerEventNode<T>::remove_node();
    }*/
    
 // Private Functions
 private:
    virtual inline void initialize_collision_handler();
    
 // Friend Functions
 public:
    
 };
 
 /** PROTECTED FUNCTIONS **/
 
 /**
  * Special Purpose Copy Constructor
  */
 template <typename T>
 CollisionHandlerPusherNode<T>::CollisionHandlerPusherNode( const CollisionHandlerPusherNode<T>& chpn, CollisionHandlerPusher* collision_handler_Ptr )
                               : CollisionHandlerEventNode( chpn, collision_handler_Ptr )
 {
    
 }
 
 /** LOCAL FUNCTIONS **/
 
 /**
  * Constructor
  *
  * @param (const std::string&) name - name for this CollisionHandlerPusherNode
  */
 template <typename T>
 CollisionHandlerPusherNode<T>::CollisionHandlerPusherNode( const std::string& name )
                               : CollisionHandlerEventNode<T>( name, true, false )
 {
    CollisionHandlerPusherNode<T>::initialize_collision_handler();
 }
 
 /**
  * Copy Constructor
  */
 template <typename T>
 CollisionHandlerPusherNode<T>::CollisionHandlerPusherNode( const CollisionHandlerPusherNode<T>& chpn )
                               : CollisionHandlerEventNode<T>( chpn )
 {
    
 }
 
 /**
  * Destructor
  */
 template <typename T>
 CollisionHandlerPusherNode<T>::~CollisionHandlerPusherNode()
 {
    if ( _collision_handler_Ptr != NULL )
    {
        PT(CollisionHandlerPusher) pusher_handler_Ptr( DCAST(CollisionHandlerPusher, _collision_handler_Ptr) );
        pusher_handler_Ptr->clear_center();
        pusher_handler_Ptr->clear_colliders();
    }
 }
 
 /**
  * operator=() copies the content of the specified CollisionHandlerPusherNode
  * to this CollisionHandlerPusherNode.
  *
  * @param (const CollisionHandlerPusherNode<T>& chpn )
  * @return CollisionHandlerPusherNode<T>&
  */
 /*template <typename T>
 inline CollisionHandlerPusherNode<T>& CollisionHandlerPusherNode<T>::operator=( const CollisionHandlerPusherNode<T>& chpn )
 {
    CollisionHandlerNode<T>::operator=( chpn );
    
    return *this;
 }*/
 
 /**
  * get_copy() returns a pointer to a CollisionHandlerEventNode that hard copies this
  * CollisionHandlerPusherNode.
  *
  * @return PT(CollisionHandlerEventNode<T>)
  */
 template <typename T>
 inline PT(CollisionHandlerEventNode<T>) CollisionHandlerPusherNode<T>::get_copy() const
 {
    return reinterpret_cast<CollisionHandlerEventNode<T>*>(new CollisionHandlerPusherNode<T>( *this, new CollisionHandlerPusher() ));
 }
 
 /**
  * reparent_to() attaches this collision handler node to the specified NodePath.
  */
 template <typename T>
 inline void CollisionHandlerPusherNode<T>::reparent_to( NodePath& node_path )
 {
    // if the collision handler has not been initialized yet
    //if ( _collision_handler_Ptr == NULL )
        //initialize_collision_handler();
    
    PT(CollisionHandlerPusher) pusher_handler_Ptr( DCAST(CollisionHandlerPusher, _collision_handler_Ptr) );
    pusher_handler_Ptr->remove_collider( *this ); // remove the previous entry for the pusher handler
    // add_collider( collision_solid_node_path, node_path_effected_by_collision )
    pusher_handler_Ptr->add_collider( *this, node_path ); // add the new entry for the pusher handler
    
    // Top: parent
    // 2nd: *this
    CollisionHandlerEventNode<T>::reparent_to( node_path );
 }
 
 /** PRIVATE FUNCTIONS **/
 
 /**
  * initialize_collision_handler() initializes the collision handling for this CollisionHandlerEventNode.
  * A CollisionHandlerPusherNode is initialized to be an "into" and "from" collider.
  */
 template <typename T>
 inline void CollisionHandlerPusherNode<T>::initialize_collision_handler()
 {
    PT(CollisionHandlerPusher) pusher_handler_Ptr( new CollisionHandlerPusher() );
    CollisionHandlerEventNode<T>::_collision_handler_Ptr = pusher_handler_Ptr;
    
    // assert the collision handler has been allocated
    nassertv( !pusher_handler_Ptr.is_null() );
    
    // add_collider( collision_solid_node_path, node_path_effected_by_collision )
    //pusher_handler_Ptr->add_collider( *this, parent );
    
    //CollisionHandlerEventNode<T>::turn_on_from_collision();
    //_is_from_collider = true;
 }
 
 /** FRIEND FUNCTIONS **/
 
 #endif // COLLISION_HANDLER_PUSHER_NODE_H